*Table 3 assets .do
*version 17
#d ;
set more off;
set linesize 120;
pause on;

cap log close;
log using "${log}99b Tables - Table 3 Assets.log", replace;

use "${CE}/ce_cpc_comb_haall_v7.dta", clear;
count;
*define asset universe;
keep if asecsurvey==0 & year>=2004 & assetintrv==1 & rliquidasset4<.;   //only non missing assets, zeros are allowed, nonmissing credit uses same intrv sample;

gen elderref=age_ref>65 & asecsurvey==0;
label var elderref "Elder Ref person (age>65)";

* liq asset indicator;
gen liqpos=.;
replace liqpos=(rliquidasset4>0 & rliquidasset4<.);
replace liqpos=0 if rliquidasset4==0;

* new credit limits from scf data;
gen credpos=.;
replace credpos=(rcreditcd4>0 & rcreditcd4<.);
replace credpos=0 if rcreditcd4==0;

gen addrcredit1 = icc_limit-rcreditcd4; //limit not based on CUR;
replace addrcredit1=0 if addrcredit1<0;
gen addrcredit2 = icc_limita-rcreditcd4; //limit based on CUR;
replace addrcredit2=0 if addrcredit2<0;

table ccgrp [aweight=c_perpopwt], stat(mean add* icchave credpos);


* define resources;

gen ce_rexpkb=c_rexpk if asec==0; // do not adjust for repayment since not counted as expenditure in ce;
gen ce_rinck=c_rinck if asec==0;

gen ce_prexpkb=ce_rexpkb<c_rspm_thres;

gen ce_rexpk_wliq=(ce_rexpkb + rliquidasset4 ) ;	//add imputed credit balance paid ;
gen ce_prexpk_wliq = (ce_rexpk_wliq < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wliq=(ce_rinck + rliquidasset4 ) ;
gen ce_princk_wliq = (ce_rinck_wliq < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wc=(ce_rexpkb + addrcredit2 ) ;	//add imputed credit balance paid ;
gen ce_prexpk_wc = (ce_rexpk_wc < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wc=(ce_rinck + addrcredit2 ) ;
gen ce_princk_wc = (ce_rinck_wc < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wliqc=(ce_rexpkb + rliquidasset4 + addrcredit2) ;
gen ce_prexpk_wliqc = (ce_rexpk_wliqc < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wliqc=(ce_rinck + rliquidasset4 + addrcredit2) ;
gen ce_princk_wliqc = (ce_rinck_wliqc < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wc1=(ce_rexpkb + addrcredit1 ) ;	
gen ce_prexpk_wc1 = (ce_rexpk_wc1 < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wc1=(ce_rinck + addrcredit1 ) ;
gen ce_princk_wc1 = (ce_rinck_wc1 < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wliqc1=(ce_rexpkb + rliquidasset4 + addrcredit1) ;
gen ce_prexpk_wliqc1 = (ce_rexpk_wliqc1 < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wliqc1=(ce_rinck + rliquidasset4 + addrcredit1) ;
gen ce_princk_wliqc1 = (ce_rinck_wliqc1 < c_rspm_thres) & rliquidasset4<. ;

replace ce_princk_wliqc=. if rliquidasset4==.|rcreditcd4==.;
replace ce_prexpk_wliqc=. if rliquidasset4==.|rcreditcd4==.;
replace ce_princk_wliqc1=. if rliquidasset4==.|rcreditcd4==.;
replace ce_prexpk_wliqc1=. if rliquidasset4==.|rcreditcd4==.;

* grossincome is after tax plus snap;
gen c_rinc_gross=.;
replace c_rinc_gross=c_rfinc_addfsm - c_rtaxm2 if c_rfinc_addfsm <. & c_rtaxm2<.;
gen c_poor_rinc_gross = c_rinc_gross < c_rspm_thres;

* compute 25th pctle;
gen pct25rinc=.;
gen pct25rexp=.;
_pctile c_rinc_gross [aweight=c_popwt] if asec==0 & inlist(year,2017,2018,2019), percentiles(25);
replace pct25rinc= c_rinc_gross <r(r1) if asec==0 & inlist(year,2017,2018,2019);
_pctile ce_rexp_noadj [aweight=c_popwt] if asec==0 & inlist(year,2017,2018,2019), percentiles(25);
replace pct25rexp= ce_rexp_noadj<r(r1) if asec==0 & inlist(year,2017,2018,2019);

gen pos_creditbal=rcreditcd4>0 & rcreditcd4<.;
gen pos_liqasset=rliquidasset4>0 & rliquidasset4<.;

* Generate stats for Table 4;
foreach var in rliquidasset4 addrcredit2 addrcredit1{;
	foreach stat in vMED vMEAN{;
		foreach survey in pct25rinc pct25rexp{;
			gen `stat'`var'`survey' = `var' if `survey' == 1 & inlist(year,2017,2018,2019);
		};
	};
};

foreach var in pos_liqasset pos_creditbal{;
	foreach survey in pct25rinc pct25rexp{;
		gen vMEAN`var'`survey' = `var' if `survey' == 1 & inlist(year,2017,2018,2019);
	};
};


gen N = 1 if inlist(year,2017,2018,2019);

preserve;
	collapse (mean) vMEAN* (p50) vMED* (sum) N [aweight=c_perpopwt], by(house_grp);
	gen elderref = 999;
	save "$temp/99b Overall.dta", replace;
restore;

collapse (mean) vMEAN* (p50) vMED* (sum) N [aweight=c_perpopwt], by(house_grp elderref);
append using "$temp/99b Overall.dta";

gen _mi_miss=0;
gen _mi_id=0;
mi extract 0, clear;
reshape long v, i(house_grp elderref N) j(variable) str;

gen stat = "MEAN" if strpos(variable,"MEAN") > 0 ;
replace stat = "MEDIAN" if strpos(variable,"MED") > 0 ;

replace variable = subinstr(variable,"MEAN","",.);
replace variable = subinstr(variable,"MED","",.);

gen asecsurvey = "REXP" if strpos(variable,"pct25rexp") > 0 ;
replace asecsurvey = "RINC" if strpos(variable,"pct25rinc") > 0 ;

replace variable = subinstr(variable,"pct25rinc","",.);
replace variable = subinstr(variable,"pct25rexp","",.);

reshape wide v N, i(house_grp variable stat asecsurvey) j(elderref);
reshape wide v0 v1 v999 N0 N1 N999, i(house_grp variable stat) j(asecsurvey) str;


replace variable = "Liquid Assets" if variable == "rliquidasset4" ;
replace variable = "Unused Credit" if variable == "addrcredit2" ;
replace variable = "Unused Credit, Alternative Imputation" if variable == "addrcredit1" ;
replace variable = "Positive Liquid Asset Balance (%)" if variable == "pos_liqasset" ;
replace variable = "Positive Credit Balance (%)" if variable == "pos_creditbal" ;

gen var_sort = 1 if variable == "Liquid Assets";
replace var_sort = 2 if variable == "Unused Credit" ;
replace var_sort = 3 if variable == "Unused Credit, Alternative Imputation" ;
replace var_sort = 4 if variable == "Positive Liquid Asset Balance (%)" ;
replace var_sort = 5 if variable == "Positive Credit Balance (%)" ;

gsort house_grp -stat var_sort;
drop var_sort;
tostring house_grp, replace ;
replace house_grp = "Owner w/ Mortgage" if house_grp == "1";
replace house_grp = "Owner w/o Mortgage" if house_grp == "2";
replace house_grp = "Renter" if house_grp == "4";

expand 2 if _n == _N ;
replace house_grp = "" if _n == _N ;
replace stat = "" if _n == _N ;
replace variable = "Frequency" if _n == _N; 

foreach survey in REXP RINC{;
	foreach age_ref in 0 1 999{;
		summ N`age_ref'`survey';
		replace v`age_ref'`survey' = `r(max)' if _n == _N ;
	};
};

keep house_grp stat variable v0REXP v1REXP v999REXP v0RINC v1RINC v999RINC;
order house_grp stat variable v0REXP v1REXP v999REXP v0RINC v1RINC v999RINC;
export excel using "${outgraph}99 Tables.xlsx", sheet("r.Table 3new") sheetreplace firstrow(variables) ; 

log close;
